/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public final class StringHelper {
    public static final String newline = new String(System.getProperty("line.separator").getBytes());

    public static String capitalize(String s2) {
        return s2.substring(0, 1).toUpperCase() + s2.substring(1);
    }

    public static String capitalizeEachWord(String s2) {
        char[] chars = s2.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (i2 != 0 && chars[i2 - 1] != ' ') continue;
            chars[i2] = ("" + chars[i2]).toUpperCase().charAt(0);
        }
        return new String(chars);
    }

    public static String getFirstWord(String s2) {
        int i2 = s2.trim().indexOf(32);
        if (i2 < 0) {
            return s2;
        }
        return s2.substring(0, i2);
    }

    public static String formatFloat(float f2, int min_num_decimal_places, int max_num_decimal_places) {
        if (min_num_decimal_places < 0 || max_num_decimal_places < 0) {
            atv.setErrorMessage("formatFloat: min_num_decimal_places or max_num_decimal_places is less than 0");
            return Float.toString(f2);
        }
        if (min_num_decimal_places > max_num_decimal_places) {
            atv.setErrorMessage("formatFloat: min_num_decimal_places > max_num_decimal_places");
            return Float.toString(f2);
        }
        String s2 = String.format("%." + max_num_decimal_places + "f", Float.valueOf(f2));
        for (int i2 = 0; i2 < max_num_decimal_places - min_num_decimal_places && s2.endsWith("0"); ++i2) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2.endsWith(".") ? s2.substring(0, s2.length() - 1) : s2;
    }

    public static String formatFloat(float f2) {
        return StringHelper.formatFloat(f2, 0, 2);
    }

    public static String formatDouble(double d2) {
        return StringHelper.formatDouble(d2, 0, 2);
    }

    public static String formatDouble(double d2, int min_num_decimal_places, int max_num_decimal_places) {
        return StringHelper.formatFloat((float)d2, min_num_decimal_places, max_num_decimal_places);
    }

    public static String getCommaSeparatedList(String[] strings) {
        StringBuffer sb2 = new StringBuffer();
        for (int i2 = 0; i2 < strings.length; ++i2) {
            sb2.append(strings[i2]);
            if (i2 >= strings.length - 1) continue;
            sb2.append(", ");
        }
        return sb2.toString();
    }

    public static String getCommaSeparatedList(Object[] objects) {
        String[] strings = new String[objects.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            strings[i2] = objects[i2].toString();
        }
        return StringHelper.getCommaSeparatedList(strings);
    }

    private String getCommaSeparatedList(List list) {
        String[] strings = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            strings[i2] = list.get(i2).toString();
        }
        return StringHelper.getCommaSeparatedList(strings);
    }

    public static String mirrorString(String s2) {
        char[] chars = s2.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            int c2 = chars[i2];
            if (c2 >= 65 && c2 <= 90) {
                c2 = 90 - (c2 - 65);
            } else if (c2 >= 97 && c2 <= 122) {
                c2 = 122 - (c2 - 97);
            } else if (c2 >= 48 && c2 <= 57) {
                c2 = 57 - (c2 - 48);
            }
            chars[i2] = (char)c2;
        }
        return new String(chars);
    }

    public static String repeat(String text, int n2) {
        StringBuffer sb2 = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            sb2.append(text);
        }
        return sb2.toString();
    }

    public static boolean startsWithVowel(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return false;
        }
        char c2 = s2.toLowerCase().charAt(0);
        return c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u';
    }

    public static boolean startsWithDigit(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return false;
        }
        char c2 = s2.charAt(0);
        return c2 >= '0' && c2 <= '9';
    }

    public static String stripLeading(String leading, String text) {
        if (leading == null || text == null || !text.startsWith(leading)) {
            return text;
        }
        return text.substring(leading.length());
    }

    public static String stripTrailing(String trailing, String text) {
        if (trailing == null || text == null || !text.endsWith(trailing)) {
            return text;
        }
        return text.substring(0, text.length() - trailing.length());
    }

    public static String left(String s2, int num_chars) {
        if (num_chars < 0) {
            num_chars = s2.length() + num_chars;
        }
        if (num_chars < 0) {
            num_chars = 0;
        }
        return s2.substring(0, num_chars);
    }

    public static String aOrAn(String next_word) {
        return (StringHelper.startsWithVowel(next_word) ? "an " : "a ") + next_word;
    }

    public static String yesOrNo(boolean b2) {
        return b2 ? "yes" : "no";
    }

    public static String getCoordsAsString(int x2, int y2, int z2) {
        return x2 + "," + y2 + "," + z2;
    }

    public static String getCoordsAsString(int[] coords) {
        return coords[0] + "," + coords[1] + "," + coords[2];
    }

    public static String getPosAsString(double pos_x, double pos_y, double pos_z, int decimal_places) {
        return StringHelper.formatDouble(pos_x, 0, decimal_places) + "," + StringHelper.formatDouble(pos_y, 0, decimal_places) + "," + StringHelper.formatDouble(pos_z, 0, decimal_places);
    }

    public static String getOnOrOff(boolean on2) {
        return on2 ? "ON" : "OFF";
    }

    public static void addToStringArray(String s2, String[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != null) continue;
            array[i2] = s2;
            return;
        }
        atv.setErrorMessage("addToStringArray: No room left in array");
    }

    public static int getNumNonNullStrings(String[] array) {
        int num = 0;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] == null) continue;
            ++num;
        }
        return num;
    }

    public static String[] explode(String s2, String delimiter) {
        if (s2 == null) {
            return null;
        }
        return s2.split(delimiter);
    }

    public static String implode(String[] string_array, String delimiter, boolean include_empties, boolean include_nulls) {
        StringBuilder sb2 = new StringBuilder();
        boolean include_delimiter = false;
        if (!(!include_nulls && string_array[0] == null || !include_empties && string_array[0].isEmpty())) {
            sb2.append(string_array[0]);
            include_delimiter = true;
        }
        for (int i2 = 1; i2 < string_array.length; ++i2) {
            if (!include_nulls && string_array[i2] == null || !include_empties && string_array[i2].isEmpty()) continue;
            if (include_delimiter) {
                sb2.append(delimiter);
            } else {
                include_delimiter = true;
            }
            sb2.append(string_array[i2]);
        }
        return sb2.toString();
    }

    public static String implode(String[] string_array, String delimiter) {
        return StringHelper.implode(string_array, delimiter, true, true);
    }

    public static String getRomanNumeral(int n2) {
        if (n2 == 1) {
            return "I";
        }
        if (n2 == 2) {
            return "II";
        }
        if (n2 == 3) {
            return "III";
        }
        if (n2 == 4) {
            return "IV";
        }
        if (n2 == 5) {
            return "V";
        }
        atv.setErrorMessage("getRomanNumeral: unhandled number " + n2);
        return "?";
    }

    public static String getBooleanAsLetter(boolean b2) {
        return b2 ? "T" : "F";
    }

    public static String convertUnderscoresToCamelCase(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.contains("_")) {
            String[] arr2 = StringHelper.explode(s2, "_");
            StringBuilder sb2 = new StringBuilder(arr2[0]);
            for (int i2 = 1; i2 < arr2.length; ++i2) {
                sb2.append(StringHelper.capitalize(arr2[i2]));
            }
            return sb2.toString();
        }
        return s2;
    }
}

